/* FILE: mono.h                                 (D. Tottingham  07/25/89)
 *
 * Copyright (c), Symmetric Research, 1988
 *
 * This is a C include file of defines, data structures, and function
 * declarations for use with the MONOCHROME library functions.  Many of these
 * values are hardware specific and should not be changed from the values
 * listed here.
 *
 * HISTORY:
 * (08/10/88) -- Added color list.
 */

#ifndef _MONO_
#define _MONO_

/* Colors. */
#define BLACK           0x00
#define BLUE            0xFF
#define GREEN           0xFF
#define CYAN            0xFF
#define RED             0xFF
#define MAGENTA         0xFF
#define BROWN           0xFF
#define LIGHT_WHITE     0xFF
#define DARK_GREY       0xFF
#define LIGHT_BLUE      0xFF
#define LIGHT_GREEN     0xFF
#define LIGHT_CYAN      0xFF
#define LIGHT_RED       0xFF
#define LIGHT_MAGENTA   0xFF
#define YELLOW          0xFF
#define WHITE           0xFF

/* Screen dimensions. */
#define MINI            0                       /* pixel ranges         */
#define MINJ            0
#define MAXI            347
#define MAXJ            719


/* Defines and global data for various set functions.  Note that these values
   have been selected to be compatabile with the EGA library. */

#define REPLACE         0x00                    /* _func values         */
#define XOR             0x18

extern int _mouse;                              /* current values       */
extern int _func;


/* Mouse defines and data structures. */
#define LEFT_BUTTON     0x01                    /* left button mask     */
#define RIGHT_BUTTON    0x02                    /* right button mask    */
typedef struct {
        int istart, jstart;                     /* initialized values   */
        int color;
        int iinc, jinc;
        int shift_iinc, shift_jinc;

        int i,j;                                /* returned data        */
        int i8x8, j8x8;
        int left, right;
        int key;
        }
        MOUSE_DATA;

/* Menu defines and data structures. */
typedef struct {
        int tag;                /* menu item identifier tag             */
        int key;                /* menu item keyboard key               */
        int i, j;               /* button coordinates                   */
        int frame;              /* button frame color                   */
        int on;                 /* on color                             */
        int off;                /* off color                            */
        char *s;                /* -> menu string                       */
        }
        MENU_DATA;


/* Function declarations for library functions using far pointers. */
plot( int, int, int far *, int, int);
plotmod( int, int, int far *, int far *, int);

#endif
